// normally the model is passed to the view instead of the view creating the model
define([
    'underscore',
    'backbone',
    'marionette',
    'modules/preferences/email-preferences-section-view',
    'modules/notification-info/notification-info-popup-view',
    'text!modules/new-appointment-request/views/common/email/info-button.html',
    'text!modules/new-appointment-request/views/common/email/templates/expressCareNotificationSettings.html',
    'text!modules/new-appointment-request/views/common/email/templates/videoVisitNotificationSettings.html',
    'text!modules/new-appointment-request/views/common/email/templates/communityCareNotificationSettings.html',
], function(
    _,
    Backbone,
    Marionette,
    EmailPreferencesSectionView,
    NotificationInfoPopup,
    _emailPreferencesInfoButton,
    expressCareNotificationSettingsTemplate,
    videoVisitNotificationSettingsTemplate,
    communityCareNotificationSettingsTemplate
) {
    'use strict';

    return EmailPreferencesSectionView.extend({
        className: 'form-section form-section-with-description',
        events: {'click #notification-info-btn': 'goToNotificationInfo'},
        initialize: function(options) {
            this.isForCommunityCare = options.isForCommunityCare || false;
            if (options.isForVideoVisit) {
                this.template = videoVisitNotificationSettingsTemplate;
            } else if (options.isForExpressCare) {
                this.template = expressCareNotificationSettingsTemplate;
            } else if (this.isForCommunityCare) {
                this.template = communityCareNotificationSettingsTemplate;
            }
            EmailPreferencesSectionView.prototype.initialize.call(this, options);
            this.overrideInitialize(options);
        },
        overrideInitialize: function(options) {
            // overrides setting of legend within prototype initialize()
            if (options.isForExpressCare || options.isForVideoVisit) {
                this.legend = 'Notification Settings';
                this.model.set('emailAllowed', true);
                // removing from the collection hides the button for information
                this.collection.remove('emailAllowed');
                this.isForVideoVisit = options.isForVideoVisit;
            } else if (options.isForCommunityCare) {
                this.legend = 'VA Scheduling Notifications';
                this.model.set('emailAllowed', true);
            } else {
                this.legend = 'Email Preferences';
            }
        },
        onRender: function() {
            // TODO get rid of chaining and test
            this.$el.find("legend[for='emailAllowed']")
                .append(_.template(_emailPreferencesInfoButton)());
            EmailPreferencesSectionView.prototype.onRender.apply(this);
        },
        goToNotificationInfo: function () {
            var uiButton = this.$el.find('#notification-info-btn');
            var notificationInfoPopup = new NotificationInfoPopup({
                elAfterClose: '#' + uiButton.attr('id'),
                isForCommunityCare: this.isForCommunityCare,
            });
            notificationInfoPopup.openPopup();
        },
    });
});
